// // // // // // // // // // // // // // // //
//
//	Enemy Territory - ServerWelt.h
//
//	erstellt 1.2.98 Andreas Warnke
//	geändert 10.5.98 von Andreas Warnke
//



#ifndef ServerWelt_h_
#define ServerWelt_h_



// // // // // // // // // // // // // // // //
//
//	include:
//

#include "Communicator.h"
#include "Spieler.h"
#include "FateMaker.h"



// // // // // // // // // // // // // // // //
//
//	ServerWelt
//

class ServerWelt : public Communicator
{
private:
	//	Zufallsgenerator:
	FateMaker Fate;
	
	//	Infos über die Spieler:
	unsigned int NextSpielerID;
	
	//	Hat jemand das Spiel gewonnen?
	unsigned int DerGewinner;
	
	//	An welcher Stelle wurde CheckBusyList abgebrochen?
	int CheckBusyListAt;
	
public:
	//	Konstruktor:
	ServerWelt ( unsigned int inMapSize );
	
	//	Destruktor:
	virtual ~ServerWelt ();
	
	//	Operationen auf die SpielerListe:
	Spieler * FindClient ( const char * inName, int inIndex = 0 );
	const char * SpielerName ( unsigned int inID );
	
	//	Operationen auf die Karte:
	void InitMap ();
	void GrowStructure (
		int inX, int inY,
		int inTyp, int inVariations,
		int inCount );
	bool OneWorld ();
	void OneWorldAddLine ( int inX, int inY, uint8 * ioBitFeld );
	
	//	Operationen auf die Objekt-Liste:
	bool NeuerSpieler ( int inSpielerID, int inArmies, int inCities );
	/*bool NeuerSpielerValidPlace ( int & outX, int & outY );*/
	int NeuerSpielerValidPlace2 ( int inX, int inY );
	bool NewArmy ( Objekt * inDorf );
	void MakeMove ( Objekt * inObj );
	void ZweiKampf ( int inX, int inY );
	void BuildVillage ( Objekt * inObj );
	bool CheckBusyList ();
	void CheckForWinner ();
	unsigned int GetWinner ();
	
	//	GetNextSpielerID;
	unsigned int GetNextSpielerID ();
};



// // // // // // // // // // // // // // // //
//
//	defines:
//



#define eNativesGetArmies 0



#endif



//
//	Ende
//
// // // // // // // // // // // // // // // //